// WL_AGENT.C

#include "WL_DEF.H"
#pragma hdrstop

/*
=============================================================================

                                                 LOCAL CONSTANTS

=============================================================================
*/

#define MAXMOUSETURN    10


#define MOVESCALE               150l
#define BACKMOVESCALE   100l
#define ANGLESCALE              20

/*
=============================================================================

                                                 GLOBAL VARIABLES

=============================================================================
*/



//
// player state info
//
boolean         running;
long            thrustspeed;

word plux,pluy;                 // player coordinates scaled to unsigned

short                   anglefrac;
short                   gotgatgun;      // JR

objtype         *LastAttacker;

/*
=============================================================================

                                                 LOCAL VARIABLES

=============================================================================
*/


void    T_Player (objtype *ob);
void    T_Attack (objtype *ob);

statetype s_player = {false,0,0,(statefunc) T_Player,NULL,NULL};
statetype s_attack = {false,0,0,(statefunc) T_Attack,NULL,NULL};


long    playerxmove,playerymove;

struct atkinf
{
        char    tics,attack,frame;              // attack is 1 for gun, 2 for knife
} attackinfo[4][14] =

{
{ {6,0,1},{6,2,2},{6,0,3},{6,-1,4} },
{ {6,0,1},{6,1,2},{6,0,3},{6,-1,4} },
{ {6,0,1},{6,1,2},{6,3,3},{6,-1,4} },
{ {6,0,1},{6,1,2},{6,4,3},{6,-1,4} },
};


short strafeangle[9] = {0,90,180,270,45,135,225,315,0};

//===========================================================================

//----------

void Attack (void);
void Use (void);
void Search (objtype *ob);
void SelectWeapon (void);
void SelectItem (void);

//----------

boolean TryMove (objtype *ob);
void T_Player (objtype *ob);

void ClipMove (objtype *ob, long xmove, long ymove);

/*
=============================================================================

                                                CONTROL STUFF

=============================================================================
*/

/*
======================
=
= CheckWeaponChange
=
= Keys 1-4 change weapons
=
======================
*/

void CheckWeaponChange (void)
{
        int     i;//,buttons;

        if (!gamestate.ammo)            // must use knife with no ammo
                return;

        for (i=wp_knife ; i<=gamestate.bestweapon ; i++)
                if (buttonstate[bt_readyknife+i-wp_knife])
                {
                        gamestate.weapon = gamestate.chosenweapon = (weapontype) i;
                        DrawWeapon ();
                        return;
                }
}


/*
=======================
=
= ControlMovement
=
= Takes controlx,controly, and buttonstate[bt_strafe]
=
= Changes the player's angle and position
=
= There is an angle hack because when going 70 fps, the roundoff becomes
= significant
=
=======================
*/

void ControlMovement (objtype *ob)
{
        long    oldx,oldy;
        int             angle;//,maxxmove;
        int             angleunits;

        thrustspeed = 0;

        oldx = player->x;
        oldy = player->y;

//
// side to side move
//
        if (buttonstate[bt_strafe])
        {
        //
        // strafing
        //
        //
                if (controlx > 0)
                {
                        angle = ob->angle - ANGLES/4;
                        if (angle < 0)
                                angle += ANGLES;
                        Thrust (angle,controlx*MOVESCALE);      // move to left
                }
                else if (controlx < 0)
                {
                        angle = ob->angle + ANGLES/4;
                        if (angle >= ANGLES)
                                angle -= ANGLES;
                        Thrust (angle,-controlx*MOVESCALE);     // move to right
                }
        }
        else
        {
        //
        // not strafing
        //
                anglefrac += controlx;
                angleunits = anglefrac/ANGLESCALE;
                anglefrac -= angleunits*ANGLESCALE;
                ob->angle -= angleunits;

                if (ob->angle >= ANGLES)
                        ob->angle -= ANGLES;
                if (ob->angle < 0)
                        ob->angle += ANGLES;

        }

//
// forward/backwards move
//
        if (controly < 0)
        {
                Thrust (ob->angle,-controly*MOVESCALE); // move forwards
        }
        else if (controly > 0)
        {
                angle = ob->angle + ANGLES/2;
                if (angle >= ANGLES)
                        angle -= ANGLES;
                Thrust (angle,controly*BACKMOVESCALE);          // move backwards
        }

        if (gamestate.victoryflag)              // watching the BJ actor
                return;

//
// calculate total move
//
        playerxmove = player->x - oldx;
        playerymove = player->y - oldy;
}

/*
=============================================================================

                                        STATUS WINDOW STUFF

=============================================================================
*/


/*
==================
=
= StatusDrawPic
=
==================
*/

void StatusDrawPic (unsigned x, unsigned y, unsigned picnum)
{
        byte *temp;

        temp = vbuf;

        vbuf = (byte *)(0xa0000 + PAGE1START+(200-STATUSLINES)*SCREENWIDTH);
        LatchDrawPic (x,y,picnum);
        vbuf = (byte *)(0xa0000 + PAGE2START+(200-STATUSLINES)*SCREENWIDTH);
        LatchDrawPic (x,y,picnum);
        vbuf = (byte *)(0xa0000 + PAGE3START+(200-STATUSLINES)*SCREENWIDTH);
        LatchDrawPic (x,y,picnum);

        vbuf = temp;
}


/*
==================
=
= DrawFace
=
==================
*/

void DrawFace (void)
{
        if (gamestate.health)
        {
                #ifdef SPEAR
                if (godmode)
                        StatusDrawPic (17,4,GODMODEFACE1PIC+gamestate.faceframe);
                else
                #endif
                StatusDrawPic (17,4,FACE1APIC+3*((100-gamestate.health)/16)+gamestate.faceframe);
        }
        else
        {
#ifndef SPEAR
         if (LastAttacker->obclass == needleobj)
           StatusDrawPic (17,4,MUTANTBJPIC);
         else
#endif
           StatusDrawPic (17,4,FACE8APIC);
        }
}

/*
===============
=
= UpdateFace
=
= Calls draw face if time to change
=
===============
*/

#define FACETICS        70

int     facecount=0;

void    UpdateFace (void)
{
        if (SD_SoundPlaying() == GETGATLINGSND)
          return;

        facecount += tics;
        if (facecount > US_RndT())
        {
                gamestate.faceframe = (US_RndT()>>6);
                if (gamestate.faceframe==3)
                        gamestate.faceframe = 1;

                facecount = 0;
                DrawFace ();
        }
}



/*
===============
=
= LatchNumber
=
= right justifies and pads with blanks
=
===============
*/

void    LatchNumber (int x, int y, int width, long number)
{
        unsigned length,c;
        char    str[20];

        ltoa (number,str,10);

        length = strlen (str);

        while (length<width)
        {
                StatusDrawPic (x,y,N_BLANKPIC);
                x++;
                width--;
        }

        c= length <= width ? 0 : length-width;

        while (c<length)
        {
                StatusDrawPic (x,y,str[c]-'0'+ N_0PIC);
                x++;
                c++;
        }
}


/*
===============
=
= DrawHealth
=
===============
*/

void    DrawHealth (void)
{
        LatchNumber (21,16,3,gamestate.health);
}


/*
===============
=
= TakeDamage
=
===============
*/

void    TakeDamage (int points,objtype *attacker)
{
        LastAttacker = attacker;

        if (gamestate.victoryflag)
                return;
        if (gamestate.difficulty==gd_baby)
          points>>=2;

        if (!godmode)
                gamestate.health -= points;

        if (gamestate.health<=0)
        {
                gamestate.health = 0;
                playstate = ex_died;
                killerobj = attacker;
        }

        if (godmode != 2)
                StartDamageFlash (points);

        gotgatgun=0;

        DrawHealth ();
        DrawFace ();

        //
        // MAKE BJ'S EYES BUG IF MAJOR DAMAGE!
        //
        #ifdef SPEAR
        if (points > 30 && gamestate.health!=0 && !godmode)
        {
                StatusDrawPic (17,4,BJOUCHPIC);
                facecount = 0;
        }
        #endif

}

/*
===============
=
= HealSelf
=
===============
*/

void    HealSelf (int points)
{
        gamestate.health += points;
        if (gamestate.health>100)
                gamestate.health = 100;

        DrawHealth ();
        gotgatgun = 0;  // JR
        DrawFace ();
}


//===========================================================================


/*
===============
=
= DrawLevel
=
===============
*/

void    DrawLevel (void)
{
#ifdef SPEAR
        if (gamestate.mapon == 20)
                LatchNumber (2,16,2,18);
        else
#endif
        LatchNumber (2,16,2,gamestate.mapon+1);
}

//===========================================================================


/*
===============
=
= DrawLives
=
===============
*/

void    DrawLives (void)
{
        LatchNumber (14,16,1,gamestate.lives);
}


/*
===============
=
= GiveExtraMan
=
===============
*/

void    GiveExtraMan (void)
{
        if (gamestate.lives<9)
                gamestate.lives++;
        DrawLives ();
        SD_PlaySound (BONUS1UPSND);
}

//===========================================================================

/*
===============
=
= DrawScore
=
===============
*/

void    DrawScore (void)
{
        LatchNumber (6,16,6,gamestate.score);
}

/*
===============
=
= GivePoints
=
===============
*/

void    GivePoints (long points)
{
        gamestate.score += points;
        while (gamestate.score >= gamestate.nextextra)
        {
                gamestate.nextextra += EXTRAPOINTS;
                GiveExtraMan ();
        }
        DrawScore ();
}

//===========================================================================

/*
==================
=
= DrawWeapon
=
==================
*/

void DrawWeapon (void)
{
        StatusDrawPic (32,8,KNIFEPIC+gamestate.weapon);
}


/*
==================
=
= DrawKeys
=
==================
*/

void DrawKeys (void)
{
        if (gamestate.keys & 1)
                StatusDrawPic (30,4,GOLDKEYPIC);
        else
                StatusDrawPic (30,4,NOKEYPIC);

        if (gamestate.keys & 2)
                StatusDrawPic (30,20,SILVERKEYPIC);
        else
                StatusDrawPic (30,20,NOKEYPIC);

// The following IF/ELSE doesn't work right
        if (gamestate.keys & 4)
                StatusDrawPic (31,4,GOLDKEYPIC);
        else
                StatusDrawPic (31,4,NOKEYPIC);

        if (gamestate.keys & 8)
                StatusDrawPic (31,20,SILVERKEYPIC);
        else
                StatusDrawPic (31,20,NOKEYPIC);


}

/*
==================
=
= GiveWeapon
=
==================
*/

void GiveWeapon (int weapon)
{
        GiveAmmo (6);

        if (gamestate.bestweapon<weapon)
                gamestate.bestweapon = gamestate.weapon
                = gamestate.chosenweapon = (weapontype) weapon;

        DrawWeapon ();
}

//===========================================================================

/*
===============
=
= DrawAmmo
=
===============
*/

void    DrawAmmo (void)
{
        LatchNumber (26,16,3,gamestate.ammo);
}

/*
===============
=
= GiveAmmo
=
===============
*/

void    GiveAmmo (int ammo)
{
        if (!gamestate.ammo)                            // knife was out
        {
                if (!gamestate.attackframe)
                {
                        gamestate.weapon = gamestate.chosenweapon;
                        DrawWeapon ();
                }
        }
        gamestate.ammo += ammo;
        if (gamestate.ammo > 99)
                gamestate.ammo = 99;
        DrawAmmo ();
}

//===========================================================================

/*
==================
=
= GiveKey
=
==================
*/

void GiveKey (int key)
{
        gamestate.keys |= (1<<key);
        DrawKeys ();
}



/*
=============================================================================

                                                        MOVEMENT

=============================================================================
*/


/*
===================
=
= GetBonus
=
===================
*/
void GetBonus (statobj_t *check)
{
        switch (check->itemnumber)
        {
        case    bo_firstaid:
                if (gamestate.health == 100)
                        return;

                SD_PlaySound (HEALTH2SND);
                HealSelf (25);
                GetMessage("Restored 25 health with first aid.");
                break;

        case    bo_key1:
        case    bo_key2:
        case    bo_key3:
        case    bo_key4:
                GiveKey (check->itemnumber - bo_key1);
                SD_PlaySound (GETKEYSND);
                GetMessage("Key to locked door obtained.");
                break;

        case    bo_cross:
                SD_PlaySound (BONUS1SND);
                GivePoints (100);
                gamestate.treasurecount++;
                GetMessage("Cross: 100 points.");
                break;
        case    bo_chalice:
                SD_PlaySound (BONUS2SND);
                GivePoints (500);
                gamestate.treasurecount++;
                GetMessage("Chalice: 500 points.");
                break;
        case    bo_bible:
                SD_PlaySound (BONUS3SND);
                GivePoints (1000);
                gamestate.treasurecount++;
                GetMessage("Treasure chest: 1000 points.");
                break;
        case    bo_crown:
                SD_PlaySound (BONUS4SND);
                GivePoints (5000);
                gamestate.treasurecount++;
                GetMessage("Crown: 5000 points!");
                break;
        case    bo_treas1:
                SD_PlaySound (BONUS1SND);
                GivePoints (400);
                gamestate.treasurecount++;
                GetMessage("Treasure 1: 400 points.");
                break;
        case    bo_treas2:
                SD_PlaySound (TREASURE2SND);
                GivePoints (800);
                gamestate.treasurecount++;
                GetMessage("Treasure 2: 800 points.");
                break;
        case    bo_treas3:
                SD_PlaySound (TREASURE3SND);
                GivePoints (1200);
                gamestate.treasurecount++;
                GetMessage("Treasure 3: 1200 points.");
                break;
        case    bo_treas4:
                SD_PlaySound (TREASURE4SND);
                GivePoints (1600);
                gamestate.treasurecount++;
                GetMessage("Treasure 4: 1600 points.");
                break;
        case    bo_treas5:
                SD_PlaySound (TREASURE2SND);
                GivePoints (2000);
                gamestate.treasurecount++;
                GetMessage("Treasure 5: 2000 points.");
                break;
        case    bo_treas6:
                SD_PlaySound (TREASURE1SND);
                GivePoints (2400);
                gamestate.treasurecount++;
                GetMessage("Treasure 6: 2400 points.");
                break;
        case    bo_treas7:
                SD_PlaySound (TREASURE3SND);
                GivePoints (2800);
                gamestate.treasurecount++;
                GetMessage("Treasure 7: 2800 points.");
                break;
        case    bo_treas8:
                SD_PlaySound (TREASURE4SND);
                GivePoints (3200);
                gamestate.treasurecount++;
                GetMessage("Treasure 8: 3200 points.");
                break;

        case    bo_clip:
                if (gamestate.ammo == 99)
                        return;

                SD_PlaySound (GETAMMOSND);
                GiveAmmo (8);
                GetMessage("Ammo clip: 8 bullets.");
                break;
        case    bo_clip2:
                if (gamestate.ammo == 99)
                        return;

                SD_PlaySound (GETAMMOSND);
                GiveAmmo (4);
                GetMessage("Used clip: 4 bullets.");
                break;

//#ifdef SPEAR
        case    bo_25clip:
                if (gamestate.ammo == 99)
                  return;

                SD_PlaySound (GETAMMOBOXSND);
                GiveAmmo (25);
                GetMessage("Ammo box: 25 bullets.");
                break;
//#endif

        case    bo_machinegun:
                SD_PlaySound (GETMACHINESND);
                GiveWeapon (wp_machinegun);
                GetMessage("Machine gun obtained.");
                break;
        case    bo_chaingun:
                SD_PlaySound (GETGATLINGSND);
                GiveWeapon (wp_chaingun);

                StatusDrawPic (17,4,GOTGATLINGPIC);
                facecount = 0;
                gotgatgun = 1;
                GetMessage("Gattlin' gun be gotten!");
                break;

        case    bo_fullheal:
                SD_PlaySound (BONUS1UPSND);
                HealSelf (99);
                GiveAmmo (25);
                GiveExtraMan ();
                gamestate.treasurecount++;
                GetMessage("1-UP: Full health and 25 ammo!");
                break;

        case    bo_food:
                if (gamestate.health == 100)
                        return;

                SD_PlaySound (HEALTH1SND);
                HealSelf (10);
                GetMessage("Turkey: 10 health.");
                break;

        case    bo_alpo:
                if (gamestate.health == 100)
                        return;

                SD_PlaySound (HEALTH1SND);
                HealSelf (4);
                GetMessage("Dog scraps: 4 health.");
                break;

        case    bo_gibs:
                if (gamestate.health >10)
                        return;

                SD_PlaySound (SLURPIESND);
                HealSelf (1);
                GetMessage("Gibs: 1 health point added.");
                break;

#ifdef SPEAR
        case    bo_spear:
                spearflag = true;
                spearx = player->x;
                speary = player->y;
                spearangle = player->angle;
                playstate = ex_completed;
#endif
        }

        StartBonusFlash ();
        check->shapenum = -1;                   // remove from list
}

/*
===================
=
= TryMove
=
= returns true if move ok
= debug: use pointers to optimize
===================
*/

boolean TryMove (objtype *ob)
{
        int                     xl,yl,xh,yh,x,y;
        objtype         *check;
        long            deltax,deltay;

        xl = (ob->x-PLAYERSIZE) >>TILESHIFT;
        yl = (ob->y-PLAYERSIZE) >>TILESHIFT;

        xh = (ob->x+PLAYERSIZE) >>TILESHIFT;
        yh = (ob->y+PLAYERSIZE) >>TILESHIFT;

                  #define PUSHWALLMINDIST (0x9000)

//
// check for solid walls
//
        for (y=yl;y<=yh;y++)
                                for (x=xl;x<=xh;x++)
                                {
                                        check = actorat[x][y];
                                        if (check && check<objlist)
                                        {
                                                if(tilemap[x][y]==64 && x==pwallx && y==pwally) // front of moving pushwall?
                                                {
                                                        switch(pwalldir)
                                                        {
                                                                case di_north:
                                                                        if(ob->y-PUSHWALLMINDIST<=(pwally<<TILESHIFT)+((63-pwallpos)<<10))
                                                                                return false;
                                                                        break;
                                                                case di_west:
                                                                        if(ob->x-PUSHWALLMINDIST<=(pwallx<<TILESHIFT)+((63-pwallpos)<<10))
                                                                                return false;
                                                                        break;
                                                                case di_east:
                                                                        if(ob->x+PUSHWALLMINDIST>=(pwallx<<TILESHIFT)+(pwallpos<<10))
                                                                                return false;
                                                                        break;
                                                                case di_south:
                                                                        if(ob->y+PUSHWALLMINDIST>=(pwally<<TILESHIFT)+(pwallpos<<10))
                                                                                return false;
                                                                        break;
                                                        }
                                                }
                                                else return false;
                                        }
                                }

//
// check for actors
//
        if (yl>0)
                yl--;
        if (yh<MAPSIZE-1)
                yh++;
        if (xl>0)
                xl--;
        if (xh<MAPSIZE-1)
                xh++;

        for (y=yl;y<=yh;y++)
                for (x=xl;x<=xh;x++)
                {
                        check = actorat[x][y];
                        if (check > objlist && (check->flags & FL_SHOOTABLE) )
                        {
                                deltax = ob->x - check->x;
                                if (deltax < -MINACTORDIST || deltax > MINACTORDIST)
                                        continue;
                                deltay = ob->y - check->y;
                                if (deltay < -MINACTORDIST || deltay > MINACTORDIST)
                                        continue;

                                return false;
                        }
                }

        return true;
}


/*
===================
=
= ClipMove
=
===================
*/

void ClipMove (objtype *ob, long xmove, long ymove)
{
        long    basex,basey;

        basex = ob->x;
        basey = ob->y;

        ob->x = basex+xmove;
        ob->y = basey+ymove;
        if (TryMove (ob))
                return;

#ifndef REMDEBUG
        if (noclip && ob->x > 2*TILEGLOBAL && ob->y > 2*TILEGLOBAL
                        && ob->x < (((long)(mapwidth-1))<<TILESHIFT)
                        && ob->y < (((long)(mapheight-1))<<TILESHIFT) )
                return;         // walk through walls
#endif

        if (!SD_SoundPlaying())
                SD_PlaySound (HITWALLSND);

        ob->x = basex+xmove;
        ob->y = basey;
        if (TryMove (ob))
                return;

        ob->x = basex;
        ob->y = basey+ymove;
        if (TryMove (ob))
                return;

        ob->x = basex;
        ob->y = basey;
}

//==========================================================================

/*
===================
=
= VictoryTile
=
===================
*/

void VictoryTile (void)
{
#ifndef SPEAR
        SpawnBJVictory ();
#endif

        gamestate.victoryflag = true;
}

/*
===================
=
= Thrust
=
===================
*/

void Thrust (int angle, long speed)
{
        long xmove,ymove;
        unsigned offset;


        //
        // ZERO FUNNY COUNTER IF MOVED!
        //
        #ifdef SPEAR
        if (speed)
                funnyticount = 0;
        #endif

        thrustspeed += speed;
//
// moving bounds speed
//
        if (speed >= MINDIST*2)
                speed = MINDIST*2-1;

        xmove = FixedMul(speed,costable[angle]);
        ymove = -FixedMul(speed,sintable[angle]);

        ClipMove(player,xmove,ymove);

        player->tilex = (short)(player->x >> TILESHIFT);                // scale to tile values
        player->tiley = (short)(player->y >> TILESHIFT);

        offset = (player->tiley<<mapshift)+player->tilex;
        player->areanumber = *(mapsegs[0] + offset) -AREATILE;

        if (*(mapsegs[1] + offset) == EXITTILE)
                VictoryTile ();
}


/*
=============================================================================

                                                                ACTIONS

=============================================================================
*/


/*
===============
=
= Cmd_Fire
=
===============
*/

void Cmd_Fire (void)
{
        buttonheld[bt_attack] = true;

        gamestate.weaponframe = 0;

        player->state = &s_attack;

        gamestate.attackframe = 0;
        gamestate.attackcount =
                attackinfo[gamestate.weapon][gamestate.attackframe].tics;
        gamestate.weaponframe =
                attackinfo[gamestate.weapon][gamestate.attackframe].frame;
}

//===========================================================================

/*
===============
=
= Cmd_Use
=
===============
*/

void Cmd_Use (void)
{
        int                     checkx,checky,doornum,dir;
        boolean         elevatorok;
        statobj_t       *statptr;

//
// find which cardinal direction the player is facing
//
        if (player->angle < ANGLES/8 || player->angle > 7*ANGLES/8)
        {
                checkx = player->tilex + 1;
                checky = player->tiley;
                dir = di_east;
                elevatorok = true;
        }
        else if (player->angle < 3*ANGLES/8)
        {
                checkx = player->tilex;
                checky = player->tiley-1;
                dir = di_north;
                elevatorok = false;
        }
        else if (player->angle < 5*ANGLES/8)
        {
                checkx = player->tilex - 1;
                checky = player->tiley;
                dir = di_west;
                elevatorok = true;
        }
        else
        {
                checkx = player->tilex;
                checky = player->tiley + 1;
                dir = di_south;
                elevatorok = false;
        }

        doornum = tilemap[checkx][checky];
        if (*(mapsegs[1]+(checky<<mapshift)+checkx) == PUSHABLETILE)
        {
        //
        // pushable wall
        //

                PushWall (checkx,checky,dir);
                return;
        }

// BT's usable objects code
        for(statptr = &statobjlist[0]; statptr != laststatobj; statptr++)
        {
            if(statptr->tilex == checkx && statptr->tiley == checky && !buttonheld[bt_use])
            {
                buttonheld[bt_use] = true;
                if(statptr->shapenum == SPR_OBJ_32)
                {
                        statptr->shapenum = CRAT_EMPTY;
                        switch (US_RndT ()%3)
                        {
                                case 0: // Ammunition
                                        SD_PlaySound (PERCENT100SND);
                                        GiveAmmo(75);
                                        GetMessage("Got 75 ammo from a crate!");
                                        StartBonusFlash ();
                                        break;
                                case 1: // Health
                                        SD_PlaySound (PERCENT100SND);
                                        HealSelf (75);
                                        GetMessage("Got 75 health from a crate!");
                                        StartBonusFlash ();
                                        break;
                                case 2: // Bomb
                                        SD_PlaySound (TAKEDAMAGESND);
                                        TakeDamage (30,NULL);
                                        GetMessage("Booby-trapped!");
                                        break;
                        }
                }

                switch (statptr->shapenum)
                {
                    case TABL_ITEM1:
                    case TABL_ITEM2:
                        GiveKey (statptr->shapenum - TABL_ITEM1);
                        SD_PlaySound (GETKEYSND);
                        GetMessage("Key to locked door obtained.");
                        statptr->shapenum = TABL_EMPTY;
                        StartBonusFlash ();
                        break;

                    case TABL_ITEM3:
                        if(gamestate.health == 100)
                        return;
                        HealSelf (10);
                        SD_PlaySound (HEALTH1SND);
                        GetMessage("Got food from a table.");
                        statptr->shapenum = TABL_EMPTY;
                        StartBonusFlash ();
                        break;

                    case TABL_ITEM4:
                        if(gamestate.health == 100)
                        return;
                        HealSelf (25);
                        SD_PlaySound (HEALTH2SND);
                        GetMessage("Got a medkit from a table.");
                        statptr->shapenum = TABL_EMPTY;
                        StartBonusFlash ();
                        break;

                    case TABL_ITEM5:
                        if(gamestate.ammo == 99)
                        return;
                        GiveAmmo(25);
                        SD_PlaySound (GETAMMOBOXSND);
                        GetMessage("Got ammo from a table.");
                        statptr->shapenum = TABL_EMPTY;
                        StartBonusFlash ();
                        break;
                }
            }
        }

        if (!buttonheld[bt_use] && doornum == ELEVATORTILE && elevatorok)
        {
        //
        // use elevator
        //
                buttonheld[bt_use] = true;

                tilemap[checkx][checky]++;              // flip switch
                if (*(mapsegs[0]+(player->tiley<<mapshift)+player->tilex) == ALTELEVATORTILE)
                        playstate = ex_secretlevel;
                else
                        playstate = ex_completed;
                SD_PlaySound (LEVELDONESND);
                SD_WaitSoundDone();
        }
        else if (!buttonheld[bt_use] && doornum & 0x80)
        {
                buttonheld[bt_use] = true;
                OperateDoor (doornum & ~0x80);
        }
        else
                SD_PlaySound (DONOTHINGSND);
}

/*
=============================================================================

                                                   PLAYER CONTROL

=============================================================================
*/



/*
===============
=
= SpawnPlayer
=
===============
*/

void SpawnPlayer (int tilex, int tiley, int dir)
{
        player->obclass = playerobj;
        player->active = ac_yes;
        player->tilex = tilex;
        player->tiley = tiley;
        player->areanumber = (byte) *(mapsegs[0]+(player->tiley<<mapshift)+player->tilex);
        player->x = ((long)tilex<<TILESHIFT)+TILEGLOBAL/2;
        player->y = ((long)tiley<<TILESHIFT)+TILEGLOBAL/2;
        player->state = &s_player;
        player->angle = (1-dir)*90;
        if (player->angle<0)
                player->angle += ANGLES;
        player->flags = FL_NEVERMARK;
        Thrust (0,0);                           // set some variables

        InitAreas ();
}


//===========================================================================

/*
===============
=
= T_KnifeAttack
=
= Update player hands, and try to do damage when the proper frame is reached
=
===============
*/

void    KnifeAttack (objtype *ob)
{
        objtype *check,*closest;
        long    dist;

        SD_PlaySound (ATKKNIFESND);
// actually fire
        dist = 0x7fffffff;
        closest = NULL;
        for (check=ob->next ; check ; check=check->next)
                if ( (check->flags & FL_SHOOTABLE)
                && (check->flags & FL_VISABLE)
                && abs(check->viewx-centerx) < shootdelta
                )
                {
                        if (check->transx < dist)
                        {
                                dist = check->transx;
                                closest = check;
                        }
                }

        if (!closest || dist> 0x18000l)
        {
        // missed

                return;
        }

// hit something
        DamageActor (closest,US_RndT() >> 4);
}



void    GunAttack (objtype *ob)
{
        objtype *check,*closest,*oldclosest;
        int             damage;
        int             dx,dy,dist;
        long    viewdist;

        switch (gamestate.weapon)
        {
        case wp_pistol:
                SD_PlaySound (ATKPISTOLSND);
                break;
        case wp_machinegun:
                SD_PlaySound (ATKMACHINEGUNSND);
                break;
        case wp_chaingun:
                SD_PlaySound (ATKGATLINGSND);
                break;
        }

        madenoise = true;

//
// find potential targets
//
        viewdist = 0x7fffffffl;
        closest = NULL;

        while (1)
        {
                oldclosest = closest;

                for (check=ob->next ; check ; check=check->next)
                        if ((check->flags & FL_SHOOTABLE) && (check->flags & FL_VISABLE)
                                        && abs(check->viewx-centerx) < shootdelta)
                        {
                                if (check->transx < viewdist)
                                {
                                        viewdist = check->transx;
                                        closest = check;
                                }
                        }

                if (closest == oldclosest)
                        return;                                         // no more targets, all missed

        //
        // trace a line from player to enemey
        //
                if (CheckLine(closest))
                        break;
        }

//
// hit something
//
        dx = ABS(closest->tilex - player->tilex);
        dy = ABS(closest->tiley - player->tiley);
        dist = dx>dy ? dx:dy;
        if (dist<2)
                damage = US_RndT() / 4;
        else if (dist<4)
                damage = US_RndT() / 6;
        else
        {
                if ( (US_RndT() / 12) < dist)           // missed
                        return;
                damage = US_RndT() / 6;
        }
        DamageActor (closest,damage);
}

//===========================================================================

/*
===============
=
= VictorySpin
=
===============
*/

void VictorySpin (void)
{
        long    desty;

        if (player->angle > 270)
        {
                player->angle -= (short)(tics * 3);
                if (player->angle < 270)
                        player->angle = 270;
        }
        else if (player->angle < 270)
        {
                player->angle += (short)(tics * 3);
                if (player->angle > 270)
                        player->angle = 270;
        }

        desty = (((long)player->tiley-5)<<TILESHIFT)-0x3000;

        if (player->y > desty)
        {
                player->y -= tics*4096;
                if (player->y < desty)
                        player->y = desty;
        }
}


//===========================================================================

/*
===============
=
= T_Attack
=
===============
*/

void    T_Attack (objtype *ob)
{
        struct  atkinf  *cur;

        UpdateFace ();

        if (gamestate.victoryflag)              // watching the BJ actor
        {
                VictorySpin ();
                return;
        }

        if ( buttonstate[bt_use] && !buttonheld[bt_use] )
                buttonstate[bt_use] = false;

        if ( buttonstate[bt_attack] && !buttonheld[bt_attack])
                buttonstate[bt_attack] = false;

        ControlMovement (ob);
        if (gamestate.victoryflag)              // watching the BJ actor
                return;

        plux = (word) (player->x >> UNSIGNEDSHIFT);                     // scale to fit in unsigned
        pluy = (word) (player->y >> UNSIGNEDSHIFT);
        player->tilex = (short)(player->x >> TILESHIFT);                // scale to tile values
        player->tiley = (short)(player->y >> TILESHIFT);

//
// change frame and fire
//
        gamestate.attackcount -= (short) tics;
        while (gamestate.attackcount <= 0)
        {
                cur = &attackinfo[gamestate.weapon][gamestate.attackframe];
                switch (cur->attack)
                {
                case -1:
                        ob->state = &s_player;
                        if (!gamestate.ammo)
                        {
                                gamestate.weapon = wp_knife;
                                DrawWeapon ();
                        }
                        else
                        {
                                if (gamestate.weapon != gamestate.chosenweapon)
                                {
                                        gamestate.weapon = gamestate.chosenweapon;
                                        DrawWeapon ();
                                }
                        };
                        gamestate.attackframe = gamestate.weaponframe = 0;
                        return;

                case 4:
                        if (!gamestate.ammo)
                                break;
                        if (buttonstate[bt_attack])
                                gamestate.attackframe -= 2;
                case 1:
                        if (!gamestate.ammo)
                        {       // can only happen with chain gun
                                gamestate.attackframe++;
                                break;
                        }
                        GunAttack (ob);
                        if (!ammocheat)
                                gamestate.ammo--;
                        DrawAmmo ();
                        break;

                case 2:
                        KnifeAttack (ob);
                        break;

                case 3:
                        if (gamestate.ammo && buttonstate[bt_attack])
                                gamestate.attackframe -= 2;
                        break;
                }

                gamestate.attackcount += cur->tics;
                gamestate.attackframe++;
                gamestate.weaponframe =
                        attackinfo[gamestate.weapon][gamestate.attackframe].frame;
        }

}



//===========================================================================

/*
===============
=
= T_Player
=
===============
*/

void    T_Player (objtype *ob)
{
        if (gamestate.victoryflag)              // watching the BJ actor
        {
                VictorySpin ();
                return;
        }

        UpdateFace ();
        CheckWeaponChange ();

        if ( buttonstate[bt_use] )
                Cmd_Use ();

        if ( buttonstate[bt_attack] && !buttonheld[bt_attack])
                Cmd_Fire ();

        ControlMovement (ob);
        if (gamestate.victoryflag)              // watching the BJ actor
                return;

        plux = (word) (player->x >> UNSIGNEDSHIFT);                     // scale to fit in unsigned
        pluy = (word) (player->y >> UNSIGNEDSHIFT);
        player->tilex = (short)(player->x >> TILESHIFT);                // scale to tile values
        player->tiley = (short)(player->y >> TILESHIFT);
}


